#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Plastic CrossMod01.fsh   by     Elsio
//https://www.shadertoy.com/view/...
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame;

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// shaders lindos ♥ https://www.shadertoy.com/playlist/cXBGzV
#define h21(p) fract(sin(dot(p, vec2(27.619, 57.583))) * 43758.5453)
#define Cor(p) fract(sin(p + p) * sin(29. * p).yx)
#define rot(a) mat2(cos(a + pi * vec4(0, .5, 1.5, 0)))
#define ang atan(1., 3.)
#define pi acos(-1.)
#define FAR 20.

float gCD;
vec2 id;

float opExtrusion(float sdf, float pz, float h, float sf) {
    vec2 w = vec2(sdf, abs(pz) - h) + sf;
    return min(max(w.x, w.y), 0.) + length(max(w, 0.)) - sf;
}

float cruz(vec2 p) {
    p = rot(ang) * p;
    vec2 b = cos(ang) / vec2(2, 6.);
    p = abs(p);
    p -= p.x < p.y ? b.yx : b;
    return max(p.x, p.y);
}

float roundCross(vec2 p, float r) {
    p = rot(ang) * p;
    vec2 b = cos(ang) / vec2(2, 6.) - .06;
    p = abs(p);
    p = p.x < p.y ? p.yx : p;
    
    vec2 q, w;
    float k, d;
    q = p - b;
    
    k = max(q.x, q.y);
    
    w = k > 0. ? q : vec2(b.y - p.x, -k);
    d = length(max(w, 0.));
    return (k > 0. ? d : -d) + r;
}


float hm(vec2 p) {
    float ret = h21(p + .5)
              + tanh(cos(h21(p + .5) * 4. + iTime * 2.) * 6.) * .35;
    
    //return .7; // stop animation
    return max(ret, .1);
}


float neig(vec2 p, out vec2 q, out vec2 id){
    id = floor(p);
    q = fract(p) - .5;
    
    return cruz(q);
}


vec2 grid(vec3 p){
    vec2 ID, Q, q;
    float a = neig(p.xy + .5, Q, ID),
          b = neig(p.xy     , q, id);
    
    if(a < b){
        id = ID + .1; 
        q = Q;
    }
    
    gCD = max(a, b) + .05;
    
    return q;
}

float map(vec3 p) {
    vec2 q = grid(p);
    float d2, h = hm(id), d;

    d2 = roundCross(q, 0.) - .05; // cross shape
    d2 = max(d2, -d2 - .14); // hole
    
    // 3D
    d = opExtrusion(d2, p.z, h, .01);
    
    d += smoothstep(.0, .1,
             abs(
                 fract(  // wall detail
                     (p.z + h) * 6.
                 ) - .5
             ) - .1
         ) * .01;
         
    d += max(d2, -.03) * .8; // top detail
    
    // sticks
    float sticks = 
        length(
            fract(
                p.xy * rot(pi / 4.) * sqrt(2.) + .5
            ) - .5
        ) - .04;
    
    id *= step(d, sticks);
    
    
    // remove sticks  
    if(iMouse.z > 0.)
        return d;
        
    return min(d, sticks);
}

float march(vec3 ro, vec3 rd) {
    float d, t;
    
    for(int i = 0; i < 96; i ++) {
        d = map(ro + rd * t);
        if(abs(d) < .001 || t > FAR) break;
        t += min(d * .9, gCD);
    }
    
    return min(t, FAR);
}


vec3 normal(vec3 p) {
    vec3 e = vec3(.01, 0, 0);
    vec3 v = vec3(
                 map(p - e.xyy),
                 map(p - e.yxy),
                 map(p - e.yyx)
             ) - map(p);
    return normalize(-v);
}


float AO(vec3 p, vec3 n) {
    float i, sca = 2., occ;
    
    while(i++ < 6.) {
        occ += (i * .04 - map(p + n * (i * .03 + .03))) * sca;
        sca *= .7;
    }
    
    return clamp(1. - occ, 0., 1.);
}


// @shane shadows
float softShadow(vec3 ro, vec3 lp, vec3 n, float k) {
    const int maxIterationsShad = 28;
    ro += n * .0015;
    vec3 rd = lp - ro;
    float shade = 1.;
    float t = 0.;
    float end = max(length(rd), .0001);
    rd /= end;
    
    for(int i = min(iFrame, 0); i < maxIterationsShad; i ++) {
        float d = map(ro + rd * t);
        shade = min(shade, k * d / t);
        t += clamp(min(d, gCD), .02, .25);
        
        if(d < 0. || t > end) break;
    }
    return max(shade, .5);
}
#define o fragColor
#define u fragCoord

// void mainImage(out vec4 o, vec2 u) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = iTime;
    vec2 r = iResolution.xy;
    u = (u + u - r) / r.y;
    
    vec3 D = normalize(vec3(u, 3)),
         p = vec3(.1, -4., -3.2),
         lp;

    //if(false) // stop the cam
        D.yz = rot(.6) * D.yz,
        p.xy *= rot(tanh(sin(t * .2) * 3.)),
        D.xy *= rot(tanh(cos(t * .2) * 3.));
    
    float a = t * .1;
    lp = p + vec3(cos(a), sin(a), 0);
    
    float d = march(p, D);
    
    o = vec4(0);
    
    if(d < FAR) {
        vec3 p = p + d * D,
             N = normal(p),
             ref = reflect(D, N);
        
        vec4 alb = length(id) > 0. ? vec4(Cor(id), Cor(id + .3)) : vec4(.3);
        float diff = length(sin(ref) * .5 - .43),
              spec = pow(diff * .9, 25.) * .06,
              sh = softShadow(p, lp, N, 16.);
              //sh = 1.; // remove shadows
        
        o = (alb * diff * .6 + spec) * AO(p, N * .1);
        fragColor = pow(o * sh, vec4(.45)) * (1. - 3. * d / FAR) * 2.;
    }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

